const { performQuery } = require("../utils/dbFunctions");
const moment = require("moment-timezone");
const { isUndefined } = require("lodash");
const { sendErrorResponse, sendResponse } = require("../utils");
const { getSystemTime, getTimezone } = require("../functions/serverTime");
const tables = require("../utils/tables");
const { getShiftData } = require("../helper/shift.helper");

// Create Attendance
module.exports.userPunchIn = async (req, res) => {
  try {
    const { user_id, line_name } = req.body;

    if (isUndefined(user_id) || isUndefined(line_name)) {
      return sendErrorResponse(res, 400, "Required Data is Missing", 400);
    }

    const systemTime = await getSystemTime();
    const Timezone = await getTimezone();
    const timestamp = moment(systemTime).format("MM/DD/YYYY HH:mm:ss");

    // console.log("systemTime: ", systemTime);
    // console.log("timestamp: ", timestamp);

    let dateIn;
    if (moment().tz(Timezone).hour() < 4) {
      dateIn = moment(systemTime).subtract(1, "days").format("MM/DD/YYYY");
    } else {
      dateIn = moment(systemTime).format("MM/DD/YYYY");
    }

    const query = {
      searchAttendanceQuery: ``,
      punch_inQuery: "",
    };
    const shiftDate = await getShiftData(timestamp);
    // console.log("shiftDate: ", shiftDate);

    if (shiftDate.length > 0) {
      const shift_name = shiftDate[0]?.shiftName;
      query.searchAttendanceQuery = `
            SELECT * FROM ${tables.attendance} 
            where 
                line_name = '${line_name}' AND
                ((date = '${dateIn}' AND shift_name = '${shift_name}' AND user_id=${user_id}) OR 
                punch_out IS NULL)`;

      const attendanceData = await performQuery(
        query.searchAttendanceQuery,
        []
      );
      if (attendanceData.length > 0) {
        return sendErrorResponse(res, 409, "Already Punch In", 409);
      }
      query.punch_inQuery = `
                        INSERT INTO ${tables.attendance} (user_id, date, shift_name, punch_in, line_name) 
                        VALUES (
                        '${user_id}','${dateIn}', '${shift_name}','${timestamp}', '${line_name}'
                        )`;

      const punch_inData = await performQuery(query.punch_inQuery, []);
      return sendResponse(res, 200, "Successfully Punch In", 200);
    }
  } catch (error) {
    console.log("error: ", error);

    return sendErrorResponse(res, error, "Error in PunchIn API");
  }
};

module.exports.userPunchOut = async (req, res) => {
  try {
    const { user_id, line_name } = req.body;

    if (isUndefined(user_id) || isUndefined(line_name)) {
      return sendErrorResponse(res, 400, "Required Data is Missing", 400);
    }

    const systemTime = await getSystemTime();
    const timeZone = await getTimezone();
    const timestamp = moment(systemTime).format("MM/DD/YYYY HH:mm:ss");
    const query = {
      searchAttendanceQuery: ``,
      punch_outQuery: "",
    };
    // const shiftDate = await performQuery(query.getShiftQuery)
    const shiftDate = await getShiftData(timestamp);

    const shift_name = shiftDate[0]?.shiftName;

    query.searchAttendanceQuery = `
            SELECT *
            FROM ${tables.attendance}
            WHERE 
                user_id = ${user_id} AND line_name = '${line_name}' AND
                punch_out IS NULL
            `;

    // console.log("searchAttendanceQuery", query.searchAttendanceQuery);

    const attendanceData = await performQuery(query.searchAttendanceQuery);

    if (attendanceData.length > 0) {
      let duration =
        (Date.parse(moment(timestamp)) -
          Date.parse(moment(attendanceData[0]?.punch_in))) /
        1000 /
        60;
      // console.log("duration >>> ", duration);
      query.punch_outQuery = `UPDATE ${tables.attendance} SET punch_out='${timestamp}', duration='${duration}', line_name = '${line_name}' WHERE id='${attendanceData[0]?.id}'`;

      const punch_outData = await performQuery(query.punch_outQuery);
      return sendResponse(res, [], "Punch Out Successfully", 200);
    }

    return sendErrorResponse(
      res,
      400,
      "Entry not Found Please PunchIn First",
      400
    );
  } catch (error) {
    console.log(error);

    return sendErrorResponse(res, error, "Error in PunchOut API");
  }
};

module.exports.userAttendance = async (req, res) => {
  try {
    const { user_id } = req.query;
    const query = `
        Select 
            a.id, u.name, u.email, a.date,
            a.shift_name, a.punch_in, a.punch_out, a.duration,
            a.line_name 
        From 
            ${tables.attendance} as a 
        Inner join 
            ${tables.users} as u 
            ON a.user_id = u.id 
        Where 
            u.id=${user_id} 
        ORDER BY 
            id DESC`;
    const attendanceData = await performQuery(query);
    if (attendanceData.length === 0) {
      return sendResponse(res, attendanceData, "No Attendance Data Found", 200);
    }

    return sendResponse(res, attendanceData, "Success", 200);
  } catch (error) {
    return sendErrorResponse(res, error, "Error getting attendance history");
  }
};

module.exports.adminAttendance = async (req, res) => {
  try {
    const { user_id } = req.query;
    const query = `
        Select 
            a.id, u.name, u.email, a.date,
            a.shift_name, a.punch_in, a.punch_out, a.duration,
            a.line_name 
        From 
            ${tables.attendance} as a 
        Inner join 
            ${tables.users} as u 
            ON a.user_id = u.id 
        ORDER BY 
            id DESC`;
    const attendanceData = await performQuery(query);
    if (attendanceData.length === 0) {
      return sendResponse(res, attendanceData, "No Attendance Data Found", 200);
    }

    return sendResponse(res, attendanceData, "Success", 200);
  } catch (error) {
    return sendErrorResponse(res, error, "Error getting attendance history");
  }
};
