const { performQuery } = require("../utils/dbFunctions");
const { sendErrorResponse, sendResponse } = require("../utils");
const tables = require("../utils/tables");

module.exports.getCurruntStatus = async (req, res) => {
  try {
    const {line_id} = req.query;
    const query = `
      SELECT 
        line_id, line, event_name, duration, stop_sub_category, comment,
        order_id, order_no, product_code, product_name, 
        total_production, machine_speed, timestamp
      FROM (
        SELECT
          dd.line_id,
          l.line,
          dd.timestamp,
          dd.machine_speed,
          RANK() OVER (PARTITION BY line_id ORDER BY dd.id DESC) AS rank,        
          dd.total_production,
          dd.status AS line_status,
          dd.order_id,
          o.order_no,
          p.product_code,
          p.product_name,
          e.event_name,
          e.duration,
          s.stop_sub_category,
          s.comment
        FROM
          ${tables.device_data} AS dd
        LEFT JOIN
          ${tables.orders} AS o
          ON dd.order_id = o.id
        LEFT JOIN
          ${tables.product} AS p
          ON o.product_id = p.id
        LEFT JOIN
          ${tables.line} AS l
          ON dd.line_id = l.id
        LEFT JOIN
          ${tables.events} AS e
          ON dd.line_id = e.line_id AND e.status = "In Progress"
        LEFT JOIN
          ${tables.stops} AS s
          ON dd.line_id = s.line_id AND s.status = "In Progress"
      ) AS RankedData
      WHERE 
        rank = 1 ${line_id ? `AND line_id = "${line_id}"` : ""}
      Order BY 
          line_id ASC;`;

    // console.log("query: ", query);

    const data = await performQuery(query);

    data.forEach((d) => {
      d.duration = d.duration/60; // converting seconds to minutes
    });

    // console.log("Data : ", data);
    if (data.length === 0) {
      return sendResponse(res, data, "No Data Found", 200);
    }
    return sendResponse(res, data, "selected Successfully", 200);
  } catch (error) {
    console.log("Error: ", error);

    return sendErrorResponse(res, error, "Error getting currunt status");
  }
};
module.exports.getSpeedDatabyTime = async (req, res) => {
  try {
    const {line_id, order_start, order_end} = req.body;
    const fetchSpeedData = await performQuery(`
      SELECT status, machine_speed, timestamp
      FROM ${tables.device_data}
      WHERE
        line_id = "${line_id}" AND (
        STR_TO_DATE(timestamp, '%Y-%m-%d %H:%i:%s')
        BETWEEN STR_TO_DATE('${order_start}', '%Y-%m-%d %H:%i:%s')
        AND STR_TO_DATE('${order_end}', '%Y-%m-%d %H:%i:%s'))`
    );

    if (fetchSpeedData.length === 0) {
      return sendResponse(res, fetchSpeedData, "No Data Found", 200);
    }
    return sendResponse(res, fetchSpeedData, "selected Successfully", 200);
  } catch (error) {
    return sendErrorResponse(res, error, "Error in getting Speed Data by Time");
  }
};
