const { performQuery } = require("../utils/dbFunctions");
const { sendErrorResponse, sendResponse } = require("../utils");
const tables = require("../utils/tables");
const { getSystemTime } = require("../functions/serverTime");
const moment = require("moment-timezone");

//=====> GET Finish Product Details against tufting_ticket_id
module.exports.getfinishProductDetails = async (req, res) => {
  try {
    const { tufting_ticket_id } = req.query;

    //====> check if the tufting_ticket_id is provided
    if (!tufting_ticket_id) {
      return sendErrorResponse(
        res,
        null,
        "Missing required parameter: tufting_ticket_id",
        400
      );
    }

    const query = `SELECT 
    fpd.id AS finish_product_detail_id,
    fpd.roll_no,
    fpd.tufting_ticket_id AS tufting_ticket_id,
    fpd.required_length AS finish_product_required_length,
    fpd.roll_length AS finish_product_roll_length,
    fpd.actual, fpd.sales_order, fpd.comments,
    tt.trolly_no AS tufting_trolly_no,
    tt.roll_length AS tufting_roll_length,
    tt.roll_size AS tufting_row_size,
    tt.width AS tufting_width,
    tt.no_of_rolls AS tufting_no_of_rolls,
    tt.completed_rolls AS tufting_completed_rolls,
    tt.pile_height AS tufting_pile_height,
    tt.total_area AS tufting_total_area
    FROM 
    ${tables.finish_product_detail} AS fpd
    LEFT JOIN
    ${tables.tufting_ticket} AS tt
    ON tt.id = fpd.tufting_ticket_id
    WHERE fpd.tufting_ticket_id = ?
    ORDER BY fpd.id DESC;
    `;

    const data = await performQuery(query, [tufting_ticket_id]);
    console.log("data => : ", data);

    if (data.length === 0) {
      return sendResponse(res, data, "No Data Found", 200);
    }
    return sendResponse(res, data, "selected Successfully", 200);
  } catch (error) {
    console.log("error => : ", error.message);
    return sendErrorResponse(
      res,
      error,
      "Error getting finishProductDetail API"
    );
  }
};

// module.exports.getfinishProductDetails = async (req, res) => {
//   try {
//     const { tufting_ticket_id } = req.query;

//     //==> Validate required parameter
//     if (!tufting_ticket_id) {
//       return sendErrorResponse(res, null, "Missing required parameter: tufting_ticket_id", 400);
//     }
//     const query = `
//       SELECT
//         fpd.id AS finish_product_detail_id,
//         fpd.roll_no,
//         fpd.tufting_ticket_id,
//         fpd.required_length AS finish_product_required_length,
//         fpd.roll_length AS finish_product_roll_length,
//         fpd.actual, fpd.sales_order, fpd.comments,
//         tt.trolly_no AS tufting_trolly_no,
//         tt.roll_length AS tufting_roll_length,
//         tt.roll_size AS tufting_row_size,
//         tt.width AS tufting_width,
//         tt.no_of_rolls AS tufting_no_of_rolls,
//         tt.completed_rolls AS tufting_completed_rolls,
//         tt.pile_height AS tufting_pile_height,
//         tt.total_area AS tufting_total_area
//       FROM
//         ${tables.finish_product_detail} AS fpd
//       LEFT JOIN
//         ${tables.tufting_ticket} AS tt
//       ON tt.id = fpd.tufting_ticket_id
//       WHERE fpd.tufting_ticket_id = ?
//       ORDER BY fpd.id DESC;
//     `;

//     const data = await performQuery(query, [tufting_ticket_id]);

//     //==> If no data found
//     if (!data.length) {
//       return sendResponse(res, [], "No Data Found", 200);
//     }

//     //==> Calculate total roll length and remaining roll length
//     const finishProductTotalRollLength = data.reduce(
//       (total, item) => total + item.finish_product_roll_length, 0
//     );

//     const tufting_remaining_roll_length = data[0].tufting_roll_length - finishProductTotalRollLength;

//     //==> Append additional calculated values
//     data.push({ finishProductTotalRollLength, tufting_remaining_roll_length });

//     console.log("data => : ", data);

//     return sendResponse(res, data, "Selected Successfully", 200);
//   } catch (error) {
//     console.error("Error =>", error.message);
//     return sendErrorResponse(res, error, "Error getting finishProductDetail API");
//   }
// };

//=====> CREATE Finish Product Detail
module.exports.createfinishProductDetail = async (req, res) => {
  try {
    const {
      tufting_ticket_id,
      roll_no,
      required_length,
      roll_length,
      actual,
      sales_order,
      comments,
      user_id,
    } = req.body;

    //====> Validation
    if (
      !tufting_ticket_id ||
      !roll_no ||
      !required_length ||
      !roll_length ||
      !user_id ||
      !sales_order
    ) {
      return sendErrorResponse(res, 400, "Required Information Missing", 400);
    }
    tuftingData = await performQuery(
      `Select * from ${tables.tufting_ticket} Where id = ?`,
      [tufting_ticket_id]
    );
    existingFPDData = await performQuery(
      `Select * from ${tables.finish_product_detail} Where tufting_ticket_id = ? AND roll_no = ? `,
      [tufting_ticket_id, roll_no]
    );
    if (tuftingData.length == 0) {
      return sendErrorResponse(res, 400, "Tufting Ticket not exists", 400);
    }
    // else if(tuftingData[0].status !== 1 || tuftingData[0].status !== 4){
    //   return sendErrorResponse(res, 400, "Tufting Ticket is already Completed", 400)
    // }
    if (existingFPDData.length > 0) {
      return sendErrorResponse(res, 409, "Roll No Already Exists", 409);
    }

    const systemTime = await getSystemTime();
    const currentTime = moment(systemTime).format("YYYY-MM-DD HH:mm:ss");

    const finshingInsertQuery = `INSERT INTO ${tables.finish_product_detail} SET ?`;
    const finishingInsertParams = [
      {
        tufting_ticket_id: tufting_ticket_id,
        roll_no: roll_no,
        required_length: required_length,
        roll_length: roll_length,
        sales_order: sales_order,
        actual: actual,
        comments: comments,
        created_at: currentTime,
        updated_at: currentTime,
        // created_by: user_id,
        // created_by: req?.user?.name,
        created_by: req?.user?.id,
        updated_by: user_id,
      },
    ];
    const finishingData = await performQuery(
      finshingInsertQuery,
      finishingInsertParams
    );
    if (finishingData.insertId > 0) {
      updateTuftingTicket = await performQuery(
        `Update ${tables.tufting_ticket} SET ? Where id=?`,
        [
          {
            completed_rolls: tuftingData[0].completed_rolls + 1,
          },
          tufting_ticket_id,
        ]
      );
      return sendResponse(res, finishingData, "created successfully", 201);
    }
    return sendErrorResponse(
      res,
      400,
      "Error in Creating Finished Product Data",
      400
    );
  } catch (error) {
    console.log("error: ", error);

    return sendErrorResponse(
      res,
      error,
      "Error in Create Finished Product API"
    );
  }
};

//=====> UPDATE Finish Product Details
module.exports.updatefinishProductDetail = async (req, res) => {
  try {
    const {
      id,
      tufting_ticket_id,
      // required_length,
      roll_length,
      sales_order,
      actual,
      comments,
    } = req.body;

    //====> Validation for id
    if (!id) {
      return sendErrorResponse(res, 400, "Required ID Missing", 400);
    }
    if (
      !tufting_ticket_id ||
      // !required_length ||
      !roll_length ||
      !sales_order
    ) {
      return sendErrorResponse(res, 400, "Required Information Missing", 400);
    }

    const systemTime = await getSystemTime();
    const currentTime = moment(systemTime).format("YYYY-MM-DD HH:mm:ss");

    const finishingUpdateQuery = `UPDATE ${tables.finish_product_detail} SET? WHERE id =?`;
    const finishingUpdateParams = [
      {
        tufting_ticket_id: tufting_ticket_id,
        // required_length: required_length,
        roll_length: roll_length,
        sales_order: sales_order,
        actual: actual,
        comments: comments,
        updated_at: currentTime,
        updated_by: req?.user?.id,
      },
      id,
    ];
    const finishingData = await performQuery(
      finishingUpdateQuery,
      finishingUpdateParams
    );

    if (finishingData.affectedRows > 0) {
      return sendResponse(res, finishingData, "updated successfully", 200);
    }
    return sendErrorResponse(res, 400, "Error in Updating Tufting Data", 400);
  } catch (error) {
    console.log("error: ", error);

    return sendErrorResponse(res, error, "Error in Update Defect Reason API");
  }
};

//=====> DELETE Finish Product Details
module.exports.deletefinishProductDetail = async (req, res) => {
  try {
    const { id } = req.params;
    if (!id) {
      return sendErrorResponse(
        res,
        null,
        "Missing required parameter: id",
        400
      );
    }
    const query = `DELETE FROM ${tables.finish_product_detail} WHERE id = ?`;
    const data = await performQuery(query, [id]);
    if (data.affectedRows > 0) {
      return sendResponse(res, data, "Deleted Successfully", 200);
    }
    return sendErrorResponse(
      res,
      null,
      "Error in Deleting Finish Product Detail",
      400
    );
  } catch (error) {
    return sendErrorResponse(
      res,
      error,
      "Error in Delete Finish Product Detail API"
    );
  }
};
