const { performQuery } = require("../utils/dbFunctions");
const { sendErrorResponse, sendResponse } = require("../utils");
const tables = require("../utils/tables");
const { getSystemTime } = require("../functions/serverTime");
const moment = require("moment-timezone");

module.exports.updateOrderDetail = async (req, res) => {
  try {
    const {
      id,
      production,
      scrap,
    } = req.body;
    const currentDate = await getSystemTime();
    const currentTime = moment(currentDate).format("YYYY-MM-DD HH:mm:ss");

    const query = `
            Update ${tables.order_details} 
            Set ?
            where id=?`;

    const params = [
      {
        production: production,
        shipable_product: parseInt(production) - parseInt(scrap),
        scrap: scrap,
        updated_by: req?.user?.id,
        updated_at: currentTime,
      },
      id,
    ];
    const data = await performQuery(query, params);

    return sendResponse(res, data, "Updated Order Details successfully", 200);
  } catch (error) {
    console.log("error in updateOrderDetail: ", error);
    return sendErrorResponse(res, error, "Error updating complete order");
  }
};

module.exports.getFilteredOrderDetails = async (req, res) => {
  try {
    const { order_start, order_end, line_id } = req.body;

    let query = `
      SELECT 
        od.id, od.line_id, l.line, od.order_id, o.order_no, p.product_code, p.product_name,
        od.shift_id, s.shift_name, od.order_start, od.order_end, od.production, od.machine_speed, od.scrap, od.shipable_product
      From ${tables.order_details} AS od
      Left JOIN ${tables.line} AS l ON od.line_id = l.id
      Left JOIN ${tables.orders} AS o ON od.order_id = o.id
      Left JOIN ${tables.product} AS p ON o.product_id = p.id
      Left JOIN ${tables.shift} AS s ON od.shift_id = s.id
      WHERE 
        STR_TO_DATE(od.order_start, '%Y-%m-%d %H:%i:%s') >= STR_TO_DATE(?, '%Y-%m-%d %H:%i:%s') 
        AND STR_TO_DATE(od.order_start, '%Y-%m-%d %H:%i:%s') <= STR_TO_DATE(?, '%Y-%m-%d %H:%i:%s') 
    `;

    if (line_id) {
      query += ` AND od.line_id = "${line_id}" `;
    }
    query += ` ORDER BY od.id DESC `;

    const data = await performQuery(query, [order_start, order_end]);

    if (data.length === 0) {
      return sendResponse(res, data, "No Data Found", 200);
    }
    return sendResponse(res, data, "selected Successfully", 200);

  } catch (error) {
    console.log("error in getFilteredOrderDetails: ", error);
    
    return sendErrorResponse(res, error,"Error getting Filtered complete orders");
  }
};
