const { performQuery } = require("../utils/dbFunctions");
const { sendErrorResponse, sendResponse } = require("../utils");
const tables = require("../utils/tables");
const moment = require("moment-timezone");
const { getSystemTime, getTimezone } = require("../functions/serverTime");

//====> GET Rewards
module.exports.getRewards = async (req, res) => {
  try {
    //==> Get system time and timezone
    const systemTime = await getSystemTime();
    // const systemTime = moment(await getSystemTime()).add(1, 'months');
    const timezone = await getTimezone();
    const currentDate = moment(systemTime).tz(timezone); 
    // const startDate = currentDate.clone().subtract(1, "months").startOf("month").format("YYYY-MM-DD");
    const startDate = currentDate.clone().subtract(1, "months").startOf("month").format("MM/DD/YYYY");
    // const endDate = currentDate.format("YYYY-MM-DD"); 
    const endDate = currentDate.format("MM/DD/YYYY"); 

    console.log("Start Date =>", startDate);
    console.log("End Date =>", endDate);

    const query = `
      SELECT 
       r.id,
       r.user_id,
       r.line_id,
       r.oee,
       r.availability,
       r.performance,
       r.quality,
       r.uptime,
       r.planned_production_time,
       r.design_speed,
       r.avg_speed,
       r.total_meters,
       r.produced,
       r.stops,
       r.downtime,
       r.co_duration,
       r.mttr,
       r.mtbf,
       r.oee_point,
       r.stops_point,
       r.co_time_point,
       r.mttr_point,
       r.mtbf_point,
       r.waste_point,
       r.production_point,
       r.total_points,
       r.shift_name,
       r.start_time,
       r.end_time,
       r.date,
       r.user_unique_data,
       u.name,
       t.teams
      FROM ${tables.reward_calculation} AS r
      LEFT JOIN ${tables.users} AS u 
      ON r.user_id = u.id 
      LEFT JOIN ${tables.teams} AS t
      ON u.team_id = t.id
      WHERE r.date BETWEEN '${startDate}' AND '${endDate}'  
      ORDER BY r.id DESC;
    `;

    const data = await performQuery(query);
    if (data.length === 0) {
      return sendResponse(res, data, "No Data Found", 200);
    }
    return sendResponse(res, data, "Select Data successfully", 200);
  } catch (error) {
    console.log("error =>", error.message);
    return sendErrorResponse(res, error, "Error getting Rewards");
  }
};
