const moment = require("moment-timezone");
const { getSystemTime } = require("../functions/serverTime");
const { getShiftData } = require("../helper/shift.helper");
const tables = require("../utils/tables");
const { performQuery } = require("../utils/dbFunctions");
const { sendResponse, sendErrorResponse } = require("../utils");

module.exports.calculateMonthlyRewardPoint = async () => {
    // const systemtime = moment(await getSystemTime()).subtract(4,'hours')
    try {
        const systemtime = moment(await getSystemTime())
        const previousDay = moment(systemtime).subtract(1,'days').startOf('day').format("MM/DD/YYYY HH:mm:ss")
        
        const orderdetailQuery = `
        SELECT 
            od.*, shift.shiftStart, shift.shiftEnd,
            o.order_id as po_number,o.order_description,
            p.product As product_code, p.product_name,
            tt.trolly_no, tt.roll_length, tt.roll_size, tt.width, tt.no_of_rolls, tt.no_of_rolls 
        FROM  ${tables.order_detail} AS od 
        LEFT JOIN ${tables.orders} AS o on od.order_id = o.id 
        LEFT JOIN ${tables.product} AS p on o.product_id = p.id 
        LEFT JOIN ${tables.tufting_ticket} tt ON od.tufting_id = tt.id
        LEFT JOIN ${tables.shift} shift ON od.shift_name = shift.shiftName
        WHERE 
            STR_TO_DATE(od.order_start, '%m/%d/%Y %H:%i:%s') >= STR_TO_DATE(?, '%m/%d/%Y %H:%i:%s') 
        ORDER BY id ASC`

        const eventQuery = `
            SELECT 
                e.line_name, e.event_name, e.start_time, 
                e.end_time, e.duration, e.speed, 
                e.shift_name, shift.shiftStart, shift.shiftEnd, e.total_area, e.status,
                e.tufting_id, e.line_id, e.user_id,
                l.line,
                u.id AS user_id, u.name, o.expected_end_date, o.order_description, 
                o.id AS orderId, o.order_id, o.expected_start_date, 
                tt.trolly_no, tt.roll_length, tt.roll_size, tt.width, tt.no_of_rolls, tt.no_of_rolls,
                p.product AS product_code, p.speed AS product_speed, p.product_name, o.expected_qty, 
                e.stop_id, s.stop_category, s.stop_sub_category, s.comment, s.downtime, s.main_stop_id, s.stop_start, s.stop_end
            FROM ${tables.events} e
                LEFT JOIN ${tables.orders} o ON e.order_id = o.id
                LEFT JOIN ${tables.shift} shift ON e.shift_name = shift.shiftName
                LEFT JOIN ${tables.line} l ON e.line_id = l.id
                LEFT JOIN ${tables.tufting_ticket} tt ON e.tufting_id = tt.id
                LEFT JOIN ${tables.product} p ON o.product_id = p.id
                LEFT JOIN ${tables.stops} s ON e.stop_id = s.id or (e.stop_id = s.main_stop_id and e.stop_id <> 0)
                LEFT JOIN ${tables.users} u ON e.user_id = u.id
            WHERE 
                STR_TO_DATE(e.start_time, '%m/%d/%Y %H:%i:%s') >= STR_TO_DATE(?, '%m/%d/%Y %H:%i:%s')
            ORDER BY 
                e.id ASC, s.stop_start ASC`;
    
        const orderDetailsData = await performQuery(orderdetailQuery, [previousDay]);
        const eventData = await performQuery(eventQuery, [previousDay]);
        console.log("Cron Job Runs at: ", moment(systemtime).format("YYYY-MM-DD HH:mm:ss"));

        const eventSortedData = {}
        const orderDetailSortedData = {}
        await orderDetailsData.map(od => {
            let date = moment(od.order_start).format("MM/DD/YYYY");
            let shiftStart = moment(`${date} ${od.shiftStart}`)
            
            if(moment(od.order_start).isSameOrBefore(shiftStart)){
                date= moment(od.order_start).subtract(1,'day').format("MM/DD/YYYY");
            }

            
            if(!orderDetailSortedData[od.line_id]){
                orderDetailSortedData[od.line_id] = {}
            }
            if(!orderDetailSortedData[od.line_id][date + " - " + od.shift_name]){
                orderDetailSortedData[od.line_id][date + " - " + od.shift_name] = {
                }
            }
            
            if(!orderDetailSortedData[od.line_id][date + " - " + od.shift_name][od.product_code]){
                orderDetailSortedData[od.line_id][date + " - " + od.shift_name][od.product_code] = 0
            }
            orderDetailSortedData[od.line_id][date + " - " + od.shift_name][od.product_code] += isNaN(parseFloat(od.scrap))? 0 : parseFloat(od.scrap);

        })

        await eventData.map(e => {
            let date = moment(e.start_time).format("MM/DD/YYYY");
            let shiftStart = moment(`${date} ${e.shiftStart}`)
            
            if(moment(e.start_time).isSameOrBefore(shiftStart)){
                date= moment(e.start_time).subtract(1,'day').format("MM/DD/YYYY");
            }

            if(!eventSortedData[e.line_id]){
                eventSortedData[e.line_id] = {}
            }
            if(!eventSortedData[e.line_id][date + " - " + e.shift_name]){
                eventSortedData[e.line_id][date + " - " + e.shift_name] = {
                    date: date,
                    shift_name: e.shift_name,
                    start_time: e.start_time,
                    line_id: e.line_id,
                    end_time: e.end_time,
                    currentShift: false,
                }
            }
            if(!eventSortedData[e.line_id][date + " - " + e.shift_name][e.user_id]){
                eventSortedData[e.line_id][date + " - " + e.shift_name][e.user_id] = {}
            }
            if(!eventSortedData[e.line_id][date + " - " + e.shift_name][e.user_id][e.product_code]){
                eventSortedData[e.line_id][date + " - " + e.shift_name][e.user_id][e.product_code] = {
                    order_id: e.order_id == null ? "Not Created" : e.order_id,
                    material_speed: e.order_id == null ? 0 : parseFloat(e.product_speed),
                    required: e.order_id == null ? 0 : parseFloat(e.expected_qty),
                    Username: e.name,
                    produced: 0,
                    changeOverTime: 0,
                    budgetTime: 0,
                    runningTime: 0,
                    downtime: 0,
                    total_area: 0,
                    avgSpeed: 0,
                    total_stops: 0,
                    jobs: [],
                };
            }
            
            // console.log("event Data: ", eventSortedData);
            eventSortedData[e.line_id][date + " - " + e.shift_name].currentShift = e.status === "In Progress"
            eventSortedData[e.line_id][date + " - " + e.shift_name].end_time = e.end_time

            // Calculate Total Production
            eventSortedData[e.line_id][date + " - " + e.shift_name][e.user_id][e.product_code].total_area +=
                // Number(eventSortedData[e.line_id][date + " - " + e.shift_name][e.user_id][e.product_code].total_area) +
                Number(e.main_stop_id === null ? Number(e?.total_area / 4) : 0);
    
            // Calculate Budget Time
            eventSortedData[e.line_id][date + " - " + e.shift_name][e.user_id][e.product_code].budgetTime +=
                // Number([e.line_id][date + " - " + e.shift_name][e.product_code].budgetTime) +
                Number(e.main_stop_id === null ? Number(e.duration) / 60 : 0);
            
            // Calculate produced (Production in Running Condition)
            eventSortedData[e.line_id][date + " - " + e.shift_name][e.user_id][e.product_code].produced +=
            //     Number(eventSortedData[e.line_id][date + " - " + e.shift_name][e.user_id][e.product_code].produced) +
                Number(e.main_stop_id === null ? e?.total_area : 0);
    
            if (e.event_name === "Running") {
                // Calculate Running Time
                eventSortedData[e.line_id][date + " - " + e.shift_name][e.user_id][e.product_code].runningTime +=
                // Number(eventSortedData[e.line_id][date + " - " + e.shift_name][e.user_id][e.product_code].runningTime) +
                Number(e.duration) / 60;
            } else if (e.stop_sub_category.includes("Changeover")) {
                // Calculate Setting Time
                eventSortedData[e.line_id][date + " - " + e.shift_name][e.user_id][e.product_code].changeOverTime += Number(e.downtime) / 60;
            }

            if (e.event_name !== "Running") {
                // Calculate Running Time
                eventSortedData[e.line_id][date + " - " + e.shift_name][e.user_id][e.product_code].total_stops += 1
                eventSortedData[e.line_id][date + " - " + e.shift_name][e.user_id][e.product_code].downtime += Number(e.downtime) / 60
            }
    
            eventSortedData[e.line_id][date + " - " + e.shift_name][e.user_id][e.product_code].avgSpeed =
                Number(eventSortedData[e.line_id][date + " - " + e.shift_name][e.user_id][e.product_code].produced) / 4 /
                Number(eventSortedData[e.line_id][date + " - " + e.shift_name][e.user_id][e.product_code].budgetTime);
    
            if (Number(eventSortedData[e.line_id][date + " - " + e.shift_name][e.user_id][e.product_code].runningTime) == 0) {
                eventSortedData[e.line_id][date + " - " + e.shift_name][e.user_id][e.product_code].avgSpeed = Number(0);
            }

            eventSortedData[e.line_id][date + " - " + e.shift_name][e.user_id][e.product_code].jobs.push({
                eventName: e.event_name == "Running" ? "Running": e.stop_sub_category,
                from: e.event_name === "Running" ? e.start_time : e.stop_start,
                to: e.event_name === "Running" ? e.end_time : e.stop_end,
                duration: e.event_name === "Running" ? Number(e.duration) / 60 : Number(e.downtime) / 60,
                meters: Number(e.total_area / 4),
                speed: Number(e.total_area / 4) / (e.event_name === "Running" ? Number(e.duration) / 60 : Number(e.downtime) / 60)//Number(e.speed),
            });
        })
        
        const lastShift = Object.keys(eventSortedData).map(line => {
            let Shifts = Object.keys(eventSortedData[line])
            const index = Shifts.findIndex(item => eventSortedData[line][item].currentShift == true);
            return eventSortedData[line][Shifts[index-1]]
        })

        const measuresForUsers = lastShift.map( s => {            
            let output = {};
            let user_id = Object.keys(s)
            user_id.map( user => {
                let sum_weighted_product_speed = 0 
                let produced = 0 
                let waste = 0 
                let total_area = 0 
                let changeOverTime = 0 
                let budgetTime = 0 
                let runningTime = 0 
                let downtime = 0 
                let total_stops = 0 
                if (user != "start_time" && user != "end_time" && user != "currentShift" && user != "date" && user != "shift_name" && user != "line_id"){
                    let products = Object.keys(s[user])
                     products.map( prod => {
                        let data = s[user][prod]
                        sum_weighted_product_speed += parseFloat(data.material_speed) * parseFloat(data.budgetTime)
                        produced += parseFloat(data.produced)
                        total_area += parseFloat(data.total_area)
                        waste += parseFloat(orderDetailSortedData[s.line_id][s.date + " - " + s.shift_name][prod])
                        changeOverTime += parseFloat(data.changeOverTime)
                        budgetTime += parseFloat(data.budgetTime)
                        runningTime += parseFloat(data.runningTime)
                        downtime += parseFloat(data.downtime)
                        total_stops += parseFloat(data.total_stops)
                    })

                    let designedSpeed = sum_weighted_product_speed/budgetTime   
                    output = {
                        user_id: Number(user),
                        line_id: Number(s.line_id),
                        oee: ((runningTime/budgetTime) * ((total_area/runningTime)/designedSpeed) * (1)) * 100,
                        availability: (runningTime/budgetTime) * 100,
                        performance: ((total_area/runningTime)/designedSpeed) * 100,
                        quality: ((total_area - waste) / total_area) * 100,
                        upTime: runningTime,
                        planned_production_time: budgetTime,
                        design_speed: designedSpeed,
                        avg_speed: (total_area/runningTime),
                        total_meters: total_area,
                        produced: produced,
                        stops: total_stops,
                        downtime: downtime,
                        co_duration: changeOverTime,
                        mttr: (budgetTime - runningTime)/ total_stops,  // Downtime Duration / No. of Stops
                        mtbf: runningTime / total_stops,                // UptimeDuration / No. of Stops 

                        // OE / OEE greater then 85% per shift = 1 point 
                        oee_point: ((runningTime/budgetTime) * ((total_area/runningTime)/designedSpeed) * (1)) > 0.85 ? 1 : 0,
                        
                        // ⁠less then 2 stops/ shift = 1 point
                        stops_point: total_stops < 2 ? 1 : 0, 
                        
                        // ⁠CO less then 45mins =1 point
                        co_time_point: changeOverTime < 45 ? 1 : 0, 

                        // ⁠⁠MTTR less then 8= 1point
                        mttr_point: (budgetTime - runningTime)/ total_stops < 8 ? 1 : 0, 

                        // ⁠⁠MTBF greater then 75 mins =1 hr 15 mins 1 point
                        mtbf_point: runningTime / total_stops > 75 ? 1 : 0,

                        // ⁠⁠waste less then 30 m = 1 point
                        waste_point: waste < 30 ? 1 : 0, 

                        // ⁠⁠production above 2000 sq meter = 1 point
                        production_point: produced > 2000 ? 1 : 0,

                        // ⁠Total point
                        total_points: (((runningTime/budgetTime) * ((total_area/runningTime)/designedSpeed) * (1)) > 0.85 ? 1 : 0) + 
                                        (total_stops < 2 ? 1 : 0) + (changeOverTime < 45 ? 1 : 0) + 
                                        ((budgetTime - runningTime)/ total_stops < 8 ? 1 : 0) + (runningTime / total_stops > 75 ? 1 : 0) + 
                                        (waste < 30 ? 1 : 0) + (produced > 2000 ? 1 : 0), 
                        shift_name: s.shift_name,
                        start_time: s.start_time,
                        end_time: s.end_time,
                        date: s.date,
                        user_unique_data: user + "-" + s.date + "-" + s.shift_name + "-" + s.line_id,
                    }       
                }
            })


            return output;
        })

        
        // Salam, for monthly reward program I am think to have below matrix:
        // - OE / OEE greater then 85% per shift = 1 point 
        // - ⁠less then 2 stops/ shift = 1 point 
        // - ⁠CO less then 45mins =1 point 
        // - ⁠MTTR less then 8= 1point 
        // - ⁠MTBF greater then 75 mins =1 hr 15 mins 1 point 
        // - ⁠waste less then 30 m = 1 point 
        // - ⁠production above 2000 sq meter = 1 point

        if (measuresForUsers.length){
            insertOrUpdateData(measuresForUsers);
        }
        else{
            console.log("No Data Found");   
        }
    } catch (error) {
        console.log("Error in Cron Job: ", error);
    }
}

async function insertOrUpdateData(dataArray) {
    if (!dataArray.length) return;

    console.log("dataArray: ", dataArray);
    
    // Extract column names dynamically
    const columns = Object.keys(dataArray[0]);
    
    // Generate placeholders for bulk insert (each row will have (?, ?, ... ?))
    const placeholders = dataArray.map(() => `(${columns.map(() => '?').join(', ')})`).join(', ');

    // Flatten values for parameterized query execution
    const values = dataArray.flatMap(Object.values);

    // Construct ON DUPLICATE KEY UPDATE statement dynamically
    const updateClause = columns
        // .filter(col => col !== 'user_unique_data') // Exclude the unique key from updating
        .map(col => `${col} = VALUES(${col})`)
        .join(', ');

    // Construct SQL query
    const query = `
        INSERT INTO ${tables.reward_calculation} (${columns.join(', ')}) 
        VALUES ${placeholders} 
        ON DUPLICATE KEY UPDATE ${updateClause}`;

    try {
        console.log("query: ", query);
        
        // Execute the query using your performQuery function
        result = await performQuery(query, values);
        console.log('Data inserted/updated successfully!', result);
    } catch (error) {
        console.error('Error inserting/updating data:', error);
    }
}

